<?php

/**
 * Shows Entries page and generates CSV reports on demand
 */
class AopsEntriesPage extends Aops {
	
	
	public function __construct() {
		
		/* Add Settings page */
		add_action( 'admin_menu', array( $this, 'addEntriesPage' ) );
		
		/* Register Table Settings */
		add_action( "load-aops_content_upgrade_page_aops-cu-entries", array( $this, 'registerTableSettings' ) );
		
		/* Define EntryColumns */
		add_filter('manage_aops_content_upgrade_page_aops-cu-entries_columns' , array($this, 'defineEntryColumns' ) );
		
		/* Saving screen options */ 
		add_filter('set-screen-option', array($this, 'saveScreenOptions'), 10, 3);
 
	}
	
    public function registerTableSettings()
    {
		$option = 'per_page';
		$args = array(
			'label' => 'Entries',
			'default' => 10,
			'option' => 'cu_entries_per_page'
		);
		add_screen_option($option, $args);
    }
	
	function saveScreenOptions($status, $option, $value) {
 
		if ( 'cu_entries_per_page' == $option ) return $value;

		return $status;

	}
	
	/**
	 * Defines custom columns
	 * @param array $columns
	 * @return array
	 */
	public function defineEntryColumns() {

		$columns = array(
			'cb'				=> '<input type="checkbox" />',
			'col_name'			=> __('First name'),
			'col_email'			=> __('Email'),
			'col_cu_id'			=> __('Content Upgrade'),
			'col_created_at'	=> __('Submitted'),
			'col_actions'		=> __('Actions')
		);
		return $columns;
	}
	
	
	public function addEntriesPage() {
		add_submenu_page( 'edit.php?post_type=' . self::$postTypeName, 
			'Content Upgrades Entries',			// page title
            'Entries',							// menu title
            'manage_options',					// capability
            'aops-cu-entries',					// slug
            array( $this, 'displayEntriesPage')	// callback);
		);
	}

	public function displayEntriesPage() {
		$entriesTable = new AopsEntriesTable();
		$entriesTable->prepare_items(); 
		?>
			<div class="wrap"><h2>Entries</h2>
				<form method="post">
					<input type="hidden" name="page" value="ttest_list_table">
					<?php
						//$entriesTable->search_box( 'search', 'search_id' );
						$entriesTable->display(); 
					?>
				</form>
			</div>

			<p>
				<a href="edit.php?generate_aops_csv=1"><?php echo __("Export these entries to CSV",'aops'); ?> </a> 
				<!-- <a href="edit.php?post_type=aops_content_upgrade&page=aops-cu-entries"><?php echo __("View entries for specific content upgrades",'aops'); ?></a> -->
			</p>
		<?php
	}

}
?>
